/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'jquerymobile', 'core/models/Model', 'hbs!modules/error-dialog/errorDialog' ], function (Portal, Backbone, Marionette, $, jqm, Model, template) {
    return Backbone.Marionette.ItemView.extend({
        template : template,
        el: '#error',
        initialize: function (options) {
            this.model = new Model({
                message: options.message
            });
        },
        onRender: function () {
            this.$el.popup({
                corners: true,
                history: false,
                transition: 'pop'
            });

            this.$el.popup('open');
            this.$el.trigger('create');
        }
    });
});
